<?php

/**
 * @package Bootscore Child
 *
 * @version 6.0.0
 */


// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Enqueue scripts and styles
 */
add_action('wp_enqueue_scripts', 'bootscore_child_enqueue_styles');
function bootscore_child_enqueue_styles() {

  // Compiled main.css
  $modified_bootscoreChildCss = date('YmdHi', filemtime(get_stylesheet_directory() . '/assets/css/main.css'));
  wp_enqueue_style('main', get_stylesheet_directory_uri() . '/assets/css/main.css', array('parent-style'), $modified_bootscoreChildCss);

  // style.css
  wp_enqueue_style('parent-style', get_template_directory_uri() . '/style.css');
  
  // custom.js
  // Get modification time. Enqueue file with modification date to prevent browser from loading cached scripts when file content changes. 
  $modificated_CustomJS = date('YmdHi', filemtime(get_stylesheet_directory() . '/assets/js/custom.js'));
  wp_enqueue_script('custom-js', get_stylesheet_directory_uri() . '/assets/js/custom.js', array('jquery'), $modificated_CustomJS, false, true);
}

// Allow SVG uploads for admins only + make them preview in the library.
add_filter('upload_mimes', function ($mimes) {
  if (current_user_can('manage_options')) {     // limit who can upload SVGs
      $mimes['svg']  = 'image/svg+xml';
      $mimes['svgz'] = 'image/svg+xml';
  }
  return $mimes;
});

register_nav_menus([
    'menu-footer-one' 	 => esc_html__('Menu Services Residential'),
	'menu-footer-two' 	 => esc_html__('Menu Services Commercial'),
    'menu-footer-three'	 => esc_html__('Menu Resources'),
	'menu-footer-four'	 => esc_html__('Menu Service Areas'),
	'services-mega-menu' => esc_html__('Services Megamanu'),
]);

// Fix MIME/preview so WordPress recognizes SVGs.
add_filter('wp_check_filetype_and_ext', function ($data, $file, $filename, $mimes) {
  $filetype = wp_check_filetype($filename, $mimes);

  if (in_array($filetype['ext'], ['svg','svgz'], true)) {
      $data['ext']             = $filetype['ext'];
      $data['type']            = 'image/svg+xml';
      $data['proper_filename'] = $data['proper_filename'] ?? $filename;
  }
  return $data;
}, 10, 4);

// Optional: show SVGs nicely in the Media Library grid.
add_action('admin_head', function () {
  echo '<style>
      .attachment .thumbnail img[src$=".svg"],
      img[src$=".svg"].attachment-post-thumbnail { width: 100% !important; height: auto !important; }
  </style>';
});

function shorten_acf_wysiwyg_height() {
    ?>
    <style>
        .acf-field-wysiwyg .acf-editor-wrap .wp-editor-area,
        .acf-field-wysiwyg .acf-editor-wrap iframe {
            min-height: 140px !important;
            height: 140px !important;
        }
    </style>
    <?php
}
add_action( 'admin_head', 'shorten_acf_wysiwyg_height' );