(function ($) {
    // Update visible fields AND the Backbone media model so the modal re-renders without a refresh
    function setAltInUI(id, alt) {
        // 1) Any visible inputs/textareas that might hold the alt text
        var selectors = [
      'textarea[name="attachments[' + id + '][image_alt]"]',
      'input[name="attachments[' + id + '][image_alt]"]',
      '#attachment_alt',
      'textarea#attachment_alt',
      // Media modal variants
      '.media-modal .setting[data-setting="alt"] input',
      '.media-modal .setting[data-setting="alt"] textarea',
      '.attachment-details .setting[data-setting="alt"] input',
      '.attachment-details .setting[data-setting="alt"] textarea'
    ];
        var $fields = $(selectors.join(','));
        if ($fields.length) {
            $fields.val(alt).trigger('input').trigger('change');
        }

        // 2) Backbone model used by wp.media
        if (window.wp && wp.media && wp.media.model && wp.media.model.Attachment) {
            var att = wp.media.model.Attachment.get(id);
            if (att) {
                att.set('alt', alt);
                att.trigger('change:alt', att, alt); // notify any bound views
            }
        }
    }

    function ensureStatus($anchor) {
        var $status = $anchor.siblings('.ctai-lite-status');
        if (!$status.length) {
            $status = $('<span class="ctai-lite-status" style="margin-left:8px;"></span>').insertAfter($anchor);
        }
        return $status;
    }

    function runGenerate(id, $status) {
        if (!$status || !$status.length) {
            $status = $('<span class="ctai-lite-status" style="margin-left:8px;"></span>');
        }
        $status.text((CTAI_LITE && CTAI_LITE.t && CTAI_LITE.t.working) || 'Generating…');

        $.post(CTAI_LITE.ajaxUrl, {
                action: 'ctai_lite_generate',
                attachment_id: id,
                nonce: CTAI_LITE.nonce
            })
            .done(function (res) {
                if (res && res.success && res.data && typeof res.data.alt !== 'undefined') {
                    var alt = res.data.alt;
                    setAltInUI(id, alt);
                    $status.text((CTAI_LITE.t && CTAI_LITE.t.ok) || 'Alt updated.');
                } else {
                    var msg = (res && res.data && res.data.message) ? res.data.message : 'Unknown error';
                    $status.text(((CTAI_LITE.t && CTAI_LITE.t.fail) || 'Failed:') + ' ' + msg);
                }
            })
            .fail(function (xhr) {
                var msg = (xhr && xhr.responseJSON && xhr.responseJSON.data && xhr.responseJSON.data.message) ?
                    xhr.responseJSON.data.message :
                    'HTTP error';
                $status.text(((CTAI_LITE.t && CTAI_LITE.t.fail) || 'Failed:') + ' ' + msg);
            });
    }

    // Button inside the media modal / attachment edit form
    $(document).on('click', '.ctai-lite-btn', function (e) {
        e.preventDefault();
        var id = $(this).data('attachment');
        if (!id) return;
        runGenerate(id, ensureStatus($(this)));
    });

    // Row action link in list view
    $(document).on('click', '.ctai-lite-row', function (e) {
        e.preventDefault();
        var id = $(this).data('attachment');
        if (!id) return;
        runGenerate(id, ensureStatus($(this)));
    });

})(jQuery);
