<?php

/**
 * Theme setup
 *
 * @package Bootscore 
 * @version 6.2.0
 */


// Exit if accessed directly.
defined('ABSPATH') || exit;


/**
 * Setup theme
 */
if (!function_exists('bootscore_setup')) :
  /**
   * Sets up theme defaults and registers support for various WordPress features.
   *
   * Note that this function is hooked into the after_setup_theme hook, which
   * runs before the init hook. The init hook is too late for some features, such
   * as indicating support for post thumbnails.
   */
  function bootscore_setup() {
    /*
     * Make theme available for translation.
     * Translations can be filed in the /languages/ directory.
     * If you're building a theme based on Bootscore, use a find and replace
     * to change 'bootscore' to the name of your theme in all the template files.
    */
    load_theme_textdomain('bootscore', get_template_directory() . '/languages');

    /*
     * Add default posts and comments RSS feed links to head.
    */
    add_theme_support('automatic-feed-links');

    /*
     * Let WordPress manage the document title.
     * By adding theme support, we declare that this theme does not use a
     * hard-coded <title> tag in the document head, and expect WordPress to
     * provide it for us.
    */
    add_theme_support('title-tag');

    /*
     * Enable support for Post Thumbnails on posts and pages.
     *
     * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
    */
    add_theme_support('post-thumbnails');

    /*
     * Switch default core markup for search form, comment form, and comments
     * to output valid HTML5.
    */
    add_theme_support('html5', array(
      'comment-form',
      'comment-list',
      'search-form',
      'gallery',
      'caption',
      'script',
      'style',
    ));

    /*
     * Add theme support for selective refresh for widgets.
    */
    add_theme_support('customize-selective-refresh-widgets');
    
    /*
     * Add theme support for block template-parts.
    */
    add_theme_support( 'block-template-parts' );
  }
endif;
add_action('after_setup_theme', 'bootscore_setup');


/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function bootscore_content_width() {
  // This variable is intended to be overruled from themes.
  // Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
  // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
  $GLOBALS['content_width'] = apply_filters('bootscore/content_width', 640);
}

add_action('after_setup_theme', 'bootscore_content_width', 0);
