<?php

$image              = get_sub_field('image');
$subheading         = get_sub_field('subheading');
$heading            = get_sub_field('heading');
$content            = get_sub_field('content');

$vertical_padding   = get_sub_field('vertical_padding');
$background_color   = get_sub_field('background_color');
$custom_class       = get_sub_field('custom_class');

// CTA groups
$primary_cta        = get_sub_field('primary_cta');
$secondary_cta      = get_sub_field('secondary_cta');

// Badges (repeater)
$badges             = get_sub_field('badges');

$bg_class = '';

if ($background_color === 'White') {
    $bg_class = 'bg-white';
} elseif ($background_color === 'Tan') {
    $bg_class = 'bg-tan';
} elseif ($background_color === 'Grey') {
    $bg_class = 'bg-grey2';
}

// Safe defaults when button_type is missing
$primary_btn_type   = !empty($primary_cta['button_type']) ? $primary_cta['button_type'] : 'green';
$secondary_btn_type = !empty($secondary_cta['button_type']) ? $secondary_cta['button_type'] : 'white';

// Assign classes
$primary_btn_class   = ($primary_btn_type === 'white') ? 'btn-cta-white' : 'btn-cta-green';
$secondary_btn_class = ($secondary_btn_type === 'green') ? 'btn-cta-green' : 'btn-cta-white';

?>

<section 
    class="hero-primary text-white <?php echo esc_attr($bg_class); ?> <?php echo esc_attr($custom_class); ?>"
    style="background-image: url('<?php echo esc_url($image); ?>');"
>
    <div class="container">
        <div class="row">
            <div class="col-md-7">

                <?php if ($subheading) : ?>
                    <div class="subheading">
                        <?php echo esc_html($subheading); ?>
                    </div>
                <?php endif; ?>

                <?php if ($heading) : ?>
                    <h1 class="my-3">
						<?php echo $heading; ?>
					</h1>
                <?php endif; ?>

                <?php if ($content) : ?>
                    <div class="p-large mb-4">
						<?php echo $content; ?>
					</div>
                <?php endif; ?>

                <div class="btn-group">

                    <?php if (!empty($primary_cta['button_link']) && !empty($primary_cta['button_text'])) : ?>
                        <a href="<?php echo esc_url($primary_cta['button_link']); ?>" class="btn-cta <?php echo esc_attr($primary_btn_class); ?>">
                            <?php echo esc_html($primary_cta['button_text']); ?>
                        </a>
                    <?php endif; ?>

                    <?php if (!empty($secondary_cta['button_link']) && !empty($secondary_cta['button_text'])) : ?>
                        <a href="<?php echo esc_url($secondary_cta['button_link']); ?>" class="btn-cta <?php echo esc_attr($secondary_btn_class); ?> ms-3">
                            <?php echo esc_html($secondary_cta['button_text']); ?>
                        </a>
                    <?php endif; ?>

                </div>

            </div>

            <div class="col-md-5">
                <!-- Right side content placeholder -->
            </div>
        </div>
    </div>

    <?php if (!empty($badges) && is_array($badges)) : ?>
        <div class="hero-badges-wrap">
            <div class="container">
                <div class="row g-4 align-items-center text-center">

                    <?php foreach ($badges as $badge) : ?>
                        <?php if (!empty($badge['badge_image'])) : ?>
                            <div class="col-md-3">
                                <img
                                    class="hero-badge"
                                    src="<?php echo esc_url($badge['badge_image']); ?>"
                                    alt=""
                                    loading="lazy"
                                >
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>

                </div>
            </div>
        </div>
    <?php endif; ?>

</section>


