<?php

$heading           = get_sub_field('heading');
$cards             = get_sub_field('card'); // repeater
$primary_cta       = get_sub_field('primary_cta');

$vertical_padding  = get_sub_field('vertical_padding');
$background_color  = get_sub_field('background_color');
$custom_class      = get_sub_field('custom_class');

$bg_class = '';
if ($background_color === 'White') {
    $bg_class = 'bg-white';
} elseif ($background_color === 'Tan') {
    $bg_class = 'bg-tan';
} elseif ($background_color === 'Grey') {
    $bg_class = 'bg-grey2';
}

$padding_top    = get_sub_field('vertical_padding_top');
$padding_bottom = get_sub_field('vertical_padding_bottom');

$padding_top_class = '';
$padding_bottom_class = '';

if ($padding_top === 'Small') {
    $padding_top_class = 'vpt-small';
} elseif ($padding_top === 'Medium') {
    $padding_top_class = 'vpt-medium';
} elseif ($padding_top === 'Large') {
    $padding_top_class = 'vpt-large';
} elseif ($padding_top === 'None') {
    $padding_top_class = 'vpt-none';
}

if ($padding_bottom === 'Small') {
    $padding_bottom_class = 'vpb-small';
} elseif ($padding_bottom === 'Medium') {
    $padding_bottom_class = 'vpb-medium';
} elseif ($padding_bottom === 'Large') {
    $padding_bottom_class = 'vpb-large';
} elseif ($padding_bottom === 'None') {
    $padding_bottom_class = 'vpb-none';
}

$btn_type  = !empty($primary_cta['button_type']) ? $primary_cta['button_type'] : 'green';
$btn_class = ($btn_type === 'white') ? 'btn-cta-white' : 'btn-cta-green';

?>

<section class="feature-cards 
    <?php echo esc_attr($padding_top_class); ?> 
    <?php echo esc_attr($padding_bottom_class); ?> 
    <?php echo esc_attr($bg_class); ?> 
    <?php echo esc_attr($custom_class); ?>
">

    <div class="container">

        <?php if ($heading) : ?>
            <h2 class="text-center mw-525 mx-auto mb-5">
                <?php echo esc_html($heading); ?>
            </h2>
        <?php endif; ?>

        <?php if (!empty($cards) && is_array($cards)) : ?>
            <div class="row g-4 justify-content-center">

                <?php foreach ($cards as $card) : ?>
                    <?php
                        $card_heading = $card['heading'] ?? '';
                        $card_image   = $card['image'] ?? '';
                    ?>
                    <div class="col-md-4 col-12">
                        <div class="feature-card text-white position-relative">

                            <?php if ($card_image) : ?>
                                <img 
                                    src="<?php echo esc_url($card_image); ?>" 
                                    alt="" 
                                    class="img-fluid w-100 rounded-4 feature-card-img"
                                >
                            <?php endif; ?>

                            <?php if ($card_heading) : ?>
                                <div class="feature-card-text">
                                    <?php echo esc_html($card_heading); ?>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>
                <?php endforeach; ?>

            </div>
        <?php endif; ?>


        <?php if (!empty($primary_cta['button_link']) && !empty($primary_cta['button_text'])) : ?>
            <div class="text-center mt-5">
                <a 
                    href="<?php echo esc_url($primary_cta['button_link']); ?>" 
                    class="btn-cta <?php echo esc_attr($btn_class); ?>"
                >
                    <?php echo esc_html($primary_cta['button_text']); ?>
                </a>
            </div>
        <?php endif; ?>

    </div>
</section>
